CREATE TABLE [dbo].[_assetFilters](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[userID] [int] NOT NULL,
	[dateTime] [smalldatetime] NOT NULL DEFAULT GETUTCDATE(),
	[filterType] [varchar](50) NOT NULL,
	[filterVal] [varchar](50) NOT NULL,
	[exclude] [bit] NOT NULL DEFAULT 0
)
GO
CREATE NONCLUSTERED INDEX _assetFilters_IX_userID ON _assetFilters (userID)
GO

--

CREATE TABLE [dbo].[_eveCharacters](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[userID] [int] NULL,
	[charID] [int] NULL,
	[eveUserID] [int] NULL,
	[charName] [varchar](50) NULL,
	[corpID] [int] NULL,
	[corpName] [varchar](50) NULL,
	[enabled] [bit] NULL,
	[dateTime] [smalldatetime] NOT NULL DEFAULT GETUTCDATE(),
	[lastUpdate] [smalldatetime] NOT NULL DEFAULT GETUTCDATE()
	--
	CONSTRAINT _eveCharacters_PK PRIMARY KEY CLUSTERED (ID)
)
GO
CREATE NONCLUSTERED INDEX _eveCharacters_IX_userID ON _eveCharacters (userID)
GO

--

CREATE TABLE [dbo].[_eveUsers](
	[userID] [int] NOT NULL,
	[eveUserID] [int] NOT NULL,
	[dateTime] [smalldatetime] NOT NULL DEFAULT GETUTCDATE(),
	[apiKey] [varchar](100) NULL
	CONSTRAINT _eveUsers_PK PRIMARY KEY CLUSTERED (userID)
)
GO

--

CREATE TABLE [dbo].[_events](
	[eventID] [int] IDENTITY(1,1) NOT NULL,
	[userID] [int] NOT NULL,
	[eveCharID] [int] NOT NULL,
	[datetime] [smalldatetime] NOT NULL DEFAULT GETUTCDATE(),
	[eventName] [varchar](50) NULL,
	[event] [varchar](500) NULL
	CONSTRAINT _events_PK PRIMARY KEY CLUSTERED (eventID)
)
GO

--

CREATE TABLE [dbo].[_jumps](
	[fromID] [int] NULL,
	[toID] [int] NULL,
	[jumpsShortest] [int] NULL,
	[jumpsSafe] [int] NULL,
	[jumpsUnsafe] [int] NULL
)
GO
CREATE NONCLUSTERED INDEX _jumps_IX_fromIDtoID ON _jumps (fromID, toID)
GO
--

CREATE TABLE [dbo].[_typePrices](
	[typeID] [int] NOT NULL,
	[price] [float] NULL,
	[dateTime] [smalldatetime] NOT NULL DEFAULT GETUTCDATE()
	CONSTRAINT _typePrices_PK PRIMARY KEY CLUSTERED (typeID)
)
GO

--

CREATE TABLE [dbo].[_users](
	[userID] [int] IDENTITY(1,1) NOT NULL,
	[userName] [varchar](50) NULL,
	[password] [varchar](50) NULL,
	[access] [tinyint] NULL,
	[apiKey] [varchar](50) NULL,
	[dateTIme] [smalldatetime] NOT NULL DEFAULT GETUTCDATE()
	CONSTRAINT _users_PK PRIMARY KEY CLUSTERED (userID)
)
GO
