import urllib2, urllib
from xml.dom import minidom
import datetime
from pprint import pprint
import functools
import time
import os
import timeit

ASSETS_FOLDER = "c:\\temp\\assets\\"
#CACHE_TIME = 0

def FuncTime(action, *args, **kwargs):
    """
    Decorator which adds boilerplate information to exported methods such as user info and page render time.
    This guy also takes care of some exception handling and redirecting away from internal pages if you're not logged in.
    """
    @functools.wraps(action)
    def wrapper(*args, **kwargs):
        startTime = time.time()
        try:
            response.title = action
            response.userinfo = XML(GetUserInfo())
            if not session.userid:
                redirect(URL('index'))
            ret = action(*args, **kwargs)
        except Exception, e:
            import sys, traceback
            exc_type, exc_value, exc_traceback = sys.exc_info()
            tb = "".join(traceback.format_exception(exc_type, exc_value, exc_traceback))
            print tb
            return "<html><h1>Emergency... There's an emergency going on...</h1><pre>%s</pre>" % tb
        response.buildtime = "%.3f" % (time.time()-startTime)
        t = "unknown"
        t = datetime.datetime.now()
        logTimes = []
        #response.nextlogs = t
        return ret
    return wrapper

# *********** EXPOSED METHODS *************

def GetEvents():
    return None

def AddEvent(name, val):
    sql = "INSERT INTO _events (userID, eveCharID, eventName, event) VALUES (%d, %d, '%s', '%s')" % (session.userid, igbdata.charid, name.replace("'", "''"), val.replace("'", "''"))
    log.LogSQL(sql)
    rows = db.executesql(sql)

@FuncTime
def EventLog():
    txt = "<h1>Event Log</h1>"
    sql = "SELECT TOP 100 * FROM _events WHERE userID = %d ORDER BY eventID DESC" % session.userid
    log.LogSQL(sql)
    rows = db.executesql(sql)
    txt += "<table><tr><th>date/time</th><th>character</th><th>event name</th><th>event description</th></tr>"
    for r in rows:
        txt += "<tr><td>%s</td><td><span class=link OnClick=\"CCPEVE.showInfo('%s', '%s');\">%s</span></td><td>%s</td><td>%s</td></tr>" % (r.datetime.strftime("%Y-%m-%d %H:%M"), util.typeCharacterDeteis, r.eveCharID, evenames.Get(r.eveCharID), r.eventName, r.event)
    txt += "</table>"
    return dict(txt=XML(txt))

def RefreshPrices():
    """
    Get average market price for all types frome eve-marketdata.com. This should be run very infrequently
    """
    typeIDs = []
    i = 0
    for typeID, t in invtypes.types.items():
        if not t.published:
            continue
        i += 1
        typeIDs.append(typeID)
        if i and i % 200 == 0:
            DoRefreshPrices(typeIDs)
            typeIDs = []
            time.sleep(5)

    DoRefreshPrices(typeIDs)
    cache.ram.clear()
    redirect(URL("index"))

@FuncTime
def types():
    """
    Returns javascript containing all types which you should copy to static/types.js
    """
    txt = """
types = new Array();
groups = new Array();
categories = new Array();
metaNames = new Array();
"""
    sql = "SELECT categoryID, categoryName FROM invCategories"
    log.LogSQL(sql)
    rs = db.executesql(sql)
    for r in rs:
        txt += "categories[%s]='%s';\n" % (r.categoryID, r.categoryName.replace("'", "\\'"))
    txt += "\n"
    sql = "SELECT groupID, groupName FROM invGroups"
    log.LogSQL(sql)
    rs = db.executesql(sql)
    for r in rs:
        txt += "groups[%s]='%s';\n" % (r.groupID, r.groupName.replace("'", "\\'"))
    txt += "\n"
    for metaNameID, metaName in util.metaNames.iteritems():
        txt += "metaNames[%s]='%s';\n" % (metaNameID, metaName.replace("'", "\\'"))
    txt += "\n"
    for typeID, type in invtypes.types.iteritems():
        #if not type.published: continue
        typeName = type.typeName.replace("'", "\\'")
        #txt += "types[%s] = ['%s', '%s', '%s', '%s', %d, %d]\n" % (typeID, typeName, groupName, categoryName, metaName, type.groupID, type.categoryID)
        txt += "types[%s]=['%s',%d,%d,%d];\n" % (typeID, typeName, type.metaNameID, type.groupID, type.categoryID)

    txt += "\n"
    return txt

def TestTime():
    txt = ""

    t = time.time()
    for i in xrange(1):
        rs = invtypes.Get(30).typeName
        print rs
    dt = time.time() - t
    txt += "Memory: %s" % dt

    t = time.time()
    for i in xrange(1):
        rs = db.executesql("SELECT * FROM invTypes WHERE typeID = 30")
        print rs[0].typeName
    dt = time.time() - t
    txt += "<br>DB: %s" % dt
    
    t = time.time()
    for i in xrange(1):
        url = "%seve/CharacterName.xml.aspx?ids=%s" % (API_URL, 30)
        dom = minidom.parse(urllib2.urlopen(url))
        row = dom.getElementsByTagName("row")[0]
        name = row.getAttribute("name")
        print name

    dt = time.time() - t
    txt += "<br>API: %s" % dt
    

    return txt
    
def DoRefreshPrices(typeIDs):
    url = "%sapi/item_prices.txt?type_ids=%s" % (MARKETDATA_URL, ",".join([str(t) for t in typeIDs]))
    txt = urllib2.urlopen(url).read()
    lst = txt.split("\n")
    prices = {}
    for t in typeIDs:
        prices[t] = 0
    for l in lst:
        if not l:
            continue
        ll = l.split("\t")
        typeID = int(ll[0])
        price = float(ll[1]) if ll[1] else 0
        prices[typeID] = price
    
    for t, p in prices.iteritems():
        sql = "DELETE FROM _typePrices WHERE typeID = %d" % t
        db.executesql(sql)
        sql = "INSERT INTO _typePrices (typeID, price) VALUES (%d, %.3f)" % (t, p)
        db.executesql(sql)

@FuncTime
def RefreshOutposts():
    """
    Get information about all player owned stations from the API and add that to eveNames and statStations.
    """
    rows = GetAPIData("eve/ConquerableStationList.xml.aspx", "", "")
    stations = [[r.getAttribute("stationID"), r.getAttribute("stationName"), r.getAttribute("solarSystemID"), r.getAttribute("corporationID"), r.getAttribute("stationTypeID")] for r in rows]
    for station in stations:
        stationID = int(station[0])
        print stationID
        stationName = station[1].replace("'", "''")
        solarSystemID = int(station[2])
        corporationID = int(station[3])
        stationTypeID = int(station[4])

        sql = "SELECT constellationID, regionID FROM mapSolarSystems WHERE solarSystemID = %d" % solarSystemID
        row = db.executesql(sql)[0]
        constellationID = int(row.constellationID)
        regionID = int(row.regionID)

        sql = "DELETE FROM eveNames WHERE itemID = %d" % stationID
        db.executesql(sql)
        sql = "INSERT INTO eveNames (itemID, itemName) VALUES (%d, '%s')" % (stationID, stationName)
        db.executesql(sql)

        sql = "DELETE FROM staStations WHERE stationID = %d" % stationID
        db.executesql(sql)
        sql = "INSERT INTO staStations (stationID, stationName, corporationID, solarSystemID, constellationID, regionID, stationTypeID) VALUES (%d, '%s', %d, %d, %d, %d, %d)" % (stationID, stationName, corporationID, solarSystemID, constellationID, regionID, stationTypeID)
        print sql
        db.executesql(sql)

    cache.ram.clear()        
    invstations.PrimeStations()
    redirect(URL("index"))

@FuncTime
def AssetsAjax():
    keys = dict(request.vars).keys()
    if not session.assetFilters or "reset" in keys:
        session.assetFilters = {}

        sql = "DELETE FROM _assetFilters WHERE userID = %d" % session.userid
        log.LogSQL(sql)
        db.executesql(sql)

    for k in keys:
        if k == "reset":
            continue
        if k.endswith("_ignore"):
            v = request.vars[k]
            if v == "reset":
                if k == "_ignore":
                    for kk in ["group", "category", "location", "type"]:
                        session.assetFilters[kk + "_ignore"] = None
                        PersistAssetFilter(kk, None)
                session.assetFilters[k] = None
                PersistAssetFilter(k, None)
            else:
                if not session.assetFilters.get(k, None):
                    session.assetFilters[k] = ""
                session.assetFilters[k] += "%s," % request.vars[k]
                PersistAssetFilter(k, session.assetFilters[k])
        else:
            v = request.vars[k]
            if v == "reset":
                v = None
            if k == "location":
                for kk in ["solarsystem", "constellation", "region"]:
                    session.assetFilters[kk] = v
                    PersistAssetFilter(kk, v)

            else:
                if v == "igb":
                    if k == "owner":
                        v = igbdata.charname.lower()
                    if k == "solarsystem":
                        v = "%s" % igbdata.solarsystemid
                        session.assetFilters["constellation"] = None
                        session.assetFilters["region"] = None
                    if k == "constellation":
                        v = "%s" % igbdata.constellationid
                        session.assetFilters["region"] = None
                        session.assetFilters["constellation"] = None
                    if k == "region":
                        v = "%s" % igbdata.regionid
                        session.assetFilters["solarsystem"] = None
                        session.assetFilters["constellation"] = None
                    print "IGB!!!", k, v
                    igbdata.DumpAll()
                session.assetFilters[k] = v
                PersistAssetFilter(k, v)

    itemsTxt, numItems, totalWorth, cachedUntil = GetItemsTxt()
    print 'returning %s items worth %s million' % (numItems, totalWorth)
    return itemsTxt

@FuncTime
def RefreshAssets():
    if not session.userid:
        redirect(URL("index"))
    mr = "?err="
    for char in session.eveCharacters:
        charID = char["charID"]
        userID = char["userID"]
        apiKey = char["apiKey"]
        cache.ram.clear("assetsforchar %s" % charID)
        try:
            i = cache.ram("assetsforchar %s" % charID, lambda:GetAssetsForChar(userID, apiKey, charID, force=True), time_expire=CACHE_TIME)
        except Exception, e:
            mr += "%s, " % e
    redirect(URL("Assets%s" % mr))

@FuncTime
def Assets():
    CheckSession()
    response.title = "Asset Buddy"
    if not session.eveCharacters:
        return dict(session=session, bindValues={})
    if request.vars.groupByStations is not None:
        groupByStations = int(request.vars.groupByStations or 0)
        session.groupByStations = groupByStations
    else:
        groupByStations = int(session.groupByStations or 0)
    if request.vars.expandContainers is not None:
        expandContainers = int(request.vars.expandContainers or 0)
        session.expandContainers = expandContainers
    else:
        expandContainers = int(session.expandContainers or 0)

    if not session.assetFilters:
        session.assetFilters = {}
    #cache.ram.clear()
    itemsTxt, numItems, totalWorth, cachedUntil = GetItemsTxt()
    if not session.eveCharacters:
        return dict(session=session)
    txt = ""
    if request.vars.err:
        txt += "<span style=\"color:red;\">%s</span>" % request.vars.err

    bindValues = { "flt": session.assetFilters.get("filter", ""),
            "sortBy": request.vars.sortBy or 0,
            "sortDir": request.vars.sortDir or 0,
            "groupByStationsNew": 0 if groupByStations else 1,
            "groupByStations": groupByStations,
            "expandContainersNew": 0 if expandContainers else 1,
            "expandContainers": expandContainers,
            "cachedUntil" : cachedUntil.strftime("%Y-%m-%d %H:%M") if cachedUntil else "unknown",
            "itemText" : T(itemsTxt),
            "cachedUntil" : cachedUntil,
            }
    return dict(session=session, bindValues=bindValues)


def logout():
    session.clear()
    response.cookies["u"] = ""
    response.cookies["p"] = ""
    redirect(URL("index"))

def index():
    message = ""
    if not session.userid:
        err = False
        txt = "<h1>Welcome, distinguished guest!</h1>"
        if "p" in request.cookies and request.cookies["p"].value and request.cookies["u"].value:
            sql = "SELECT password FROM _users WHERE LOWER(userName) = '%s'" % request.cookies["u"].value
            print sql
            try:
                pas = db.executesql(sql)[0].password
                import hashlib
                m = hashlib.md5()
                m.update(pas)
                pc = m.digest()
                if pc == request.cookies["p"].value:
                    request.vars.username = request.cookies["u"].value
                    request.vars.password = pas
            except Exception, e:
                print "Error in autologin", e

        if request.vars.username and request.vars.password:
            u = request.vars.username.lower().replace("'", "''")
            p = request.vars.password.lower().replace("'", "''")
            sql = "SELECT * FROM _users WHERE LOWER(userName) = '%s' AND LOWER(password) = '%s'" % (u, p)
            rows = db.executesql(sql)
            if not rows:
                err = True
            else:
                remember = not not request.vars.remember
                if remember:
                    print "remembering..."
                    import hashlib
                    m = hashlib.md5()
                    m.update(p)
                    pc = m.digest()
                    response.cookies["p"] = pc
                    response.cookies["u"] = u
                    response.cookies["u"]["expires"] = 3600*24*30
                    response.cookies["p"]["expires"] = 3600*24*30

                SetupUserSession(rows[0].userID, rows[0].userName)
                redirect(URL("index"))
        if err:
            message = "Username or password incorrect. Please try again."
    if request.vars.msg:
        message += "<span style=\"color:green\">%s</span>" % request.vars.msg
    
    return dict(session=session, message=message)

def NewUser():
    if request.vars.submit and request.vars.newusername and request.vars.newpassword:
        u = request.vars.newusername.replace("'", "''").lower()
        p = request.vars.newpassword.replace("'", "''")
        sql = "SELECT * FROM _users WHERE userName LIKE '%s' " % u
        rows = db.executesql(sql)
        if len(rows) > 0:
            redirect(URL('NewUser?error=User %s Already Exists' % request.vars.newusername))
        try:
            sql = "INSERT INTO _users (userName, password) VALUES ('%s', '%s')" % (u, p)
            rows = db.executesql(sql)
        except:
            redirect(URL('NewUser?error=There was an error creating your user account. Chances are that you are being a dick'))
        redirect(URL('index?msg=User Account created. Please log-in'))
    response.title = "New User"
    return dict(txt=XML(request.vars.error or ""))

@FuncTime
def Research():
    response.title = "Research Assistant"
    agents = []
    if not session.eveCharacters:
        return dict(session=session)
    if session.eveCharacters:
        for char in session.eveCharacters:
            apiKey = char["apiKey"]
            userID = char["userID"]
            charID = char["charID"]
            charName = char["charName"]
            rows = GetAPIData("char/Research.xml.aspx", userID, apiKey, charID)

            for r in rows:
                agentID = int(r.getAttribute("agentID"))
                skillTypeID = int(r.getAttribute("skillTypeID"))
                agent = {
                    "charID"        : charID,
                    "agentID"       : agentID,
                    "pointsPerDay"  : float(r.getAttribute("pointsPerDay")),
                    "remainder"     : float(r.getAttribute("remainderPoints")),
                    "startDate"     : r.getAttribute("researchStartDate"),
                    "skillTypeID"   : skillTypeID,
                    "charName"      : charName,
                    }
                sql = """
                SELECT a.agentID, a.corporationID, a.locationID, a.level, a.quality, s.solarSystemID, s.stationName
                  FROM agtAgents a
                    INNER JOIN staStations s ON s.stationID = a.locationID
                WHERE a.agentID = %s
                """ % agentID
                row = db.executesql(sql)[0]

                agent["stationID"] = row.locationID
                agent["solarSystemID"] = row.solarSystemID
                agent["level"] = row.level
                agent["quality"] = row.quality
                agent["stationName"] = row.stationName
                agent["corporationID"] = row.corporationID

                sql = """SELECT typeID FROM dgmTypeAttributes 
                 WHERE attributeID = 182 
                 AND valueInt = %s
                """ % skillTypeID
                row = db.executesql(sql)[0]
                agent["coreTypeID"] = row.typeID
                sql = """SELECT valueInt FROM dgmTypeAttributes 
                          WHERE typeID = %s AND attributeID = 1155
                      """ % row.typeID
                row = db.executesql(sql)[0]
                agent["pointsPerCore"] = int(row.valueInt)
                agents.append(agent)

    solarSystemIDs = set()
    corePrices = {}
    for a in agents:
        if request.vars.characterID and int(a["charID"]) != int(request.vars.characterID):
            continue
        solarSystemIDs.add(a["solarSystemID"])
        corePrices[a["coreTypeID"]] = 0

    for typeID in corePrices.keys():
        corePrices[typeID] = invtypes.Get(typeID).price
    mySolarSystemID = igbdata.solarSystemID or 0
    invsolarsystems.PrimeJumps(mySolarSystemID, solarSystemIDs)

    agentTxt = []
    totValue = 0
    for agent in agents:
        charID = int(agent["charID"])
        if request.vars.characterID and charID != int(request.vars.characterID):
            continue
        date_object = datetime.datetime.strptime(agent["startDate"], '%Y-%m-%d %H:%M:%S')
        diff = datetime.datetime.today() - date_object
        numPoints = agent["pointsPerDay"] * diff.days + agent["remainder"]
        pointsPerCore = agent["pointsPerCore"]
        numCores = int(numPoints/pointsPerCore)
        solarSystemID = agent["solarSystemID"]
        jumps = invsolarsystems.GetJumps(mySolarSystemID, solarSystemID)
        name = evenames.Get(agent["agentID"])
        corpName = evenames.Get(agent["corporationID"])
        coreTypeID = agent["coreTypeID"]
        corePrice = (numCores * (corePrices.get(coreTypeID, 0) or 0))
        totValue += corePrice
        corePrice = int(corePrice/1000000)
        t = """<tr class=agent agentTypeID="%s" agentID="%s" solarSystemID="%s" coreTypeID="%s" characterID="%s">
            <td><img src=\"http://image.eveonline.com/Character/%s_32.jpg\"></td>
            <td>%s</td>
            <td><img src=\"http://image.eveonline.com/Character/%s_32.jpg\"></td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            <td>%.0f</td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            <td>%s</td>
            </tr>""" % (1377, agent["agentID"], solarSystemID, coreTypeID, charID, charID, agent["charName"], agent["agentID"], name, corpName, invtypes.Get(agent["skillTypeID"]).typeName, numPoints, agent["pointsPerDay"], numCores, agent["level"], agent["quality"], agent["stationName"], jumps, corePrice)
        agentTxt.append((name, t))

    txt = ""
    agentTxt.sort()
    for a in agentTxt:
        txt += a[1]
    return dict(
        session=session,
        table=XML(txt),
        total=H1("Total datacore value: %.0f million ISK" % (totValue/1000000)),
        waypoints=",".join([str(s) for s in solarSystemIDs]))

@FuncTime
def Settings():
    if request.vars.clearcache:
        cache.ram.clear()
    MAX_USERS = 5
    if request.vars.submit:
        cache.ram.clear() #! TODO

        sql = "DELETE FROM _eveUsers WHERE userID = %d" % session.userid
        db.executesql(sql)
        for i in xrange(MAX_USERS):
            try:
                eveUserID = int(getattr(request.vars, "eveUserID_%s" % i))
                apiKey = getattr(request.vars, "apiKey_%s" % i)
                sql = "INSERT INTO _eveUsers (userID, eveUserID, apiKey) VALUES (%d, %d, '%s')" % (session.userid, eveUserID, apiKey.replace("'", "''"))
                db.executesql(sql)
            except Exception, e:
                print e
                pass
        PopulateMyCharacters()
        SetupUserSession(session.userid, session.username)
        for userID, apiKey in session.eveUsers.iteritems():
            print userID
        for char in session.eveCharacters:
            print char["userID"], char["charID"], char["charName"]
        print
        redirect(URL('Settings'))
    response.title = "User Settings"
    PopulateMyCharacters()
    SetupUserSession(session.userid, session.username)
    txt = ""
    sql = "SELECT * FROM _eveUsers WHERE userID = %d" % session.userid
    rows = db.executesql(sql)
    lines = []
    i = -1
    for i, r in enumerate(rows):
        try:
            dom = GetAPIDom("account/AccountStatus.xml.aspx", r.eveUserID, r.apiKey, "")
            s = str(dom.toprettyxml()).lower()
            icon = "check.png"
            err = "This user is good to go!"
            if "error" in s:
                err = "Unknown error"
                icon = "delete.png"

                if "security" in s:
                    err = "This is a limited API Key. Full API key is required"
                elif "authentication" in s:
                    err = "Authentication error. This API key and user ID do not match"
        except:
            icon = "delete.png"
            err = "There was an error retrieving information from the API for this user"
        lines.append([i, r.eveUserID, i, r.apiKey, URL("static/images", icon), err])
    return dict(txt=XML(txt), maxUsers=MAX_USERS, lines=lines)

def CheckSession():
    """
        Called by js to check whether we've switched solarsystems, in which case we reload the page
    """
    ret = ""
    if session.solarsystemid != igbdata.solarsystemid:
        log.LogInfo("CheckSession solarsystemid", session.solarsystemid, igbdata.solarsystemid)
        AddEvent("Moving between systems", "Moved from solar system %s to solar system %s" % (evenames.Get(session.solarsystemid), evenames.Get(igbdata.solarsystemid)))
        session.solarsystemid = igbdata.solarsystemid
        ret = "RELOAD"
    if session.stationid != igbdata.stationid:
        log.LogInfo("CheckSession stationid", session.stationid, igbdata.stationid)
        if session.stationid and igbdata.stationid:
            AddEvent("Moving between stations", "Moved from station %s to station %s" % (evenames.Get(session.stationid), evenames.Get(igbdata.stationid)))
        elif session.stationid:
            AddEvent("Exited station", "Exited station %s" % (evenames.Get(session.stationid)))
        elif igbdata.stationid:
            AddEvent("Entered station", "Entered station %s" % (evenames.Get(igbdata.stationid)))
        session.stationid = igbdata.stationid
    if session.shipid != igbdata.shipid:
        log.LogInfo("CheckSession shipid", session.shipid, igbdata.shipid)
        AddEvent("Changed ships", "Changed from %s to %s" % (invtypes.Get(session.shiptypeid).typeName if session.shiptypeid else "None", invtypes.Get(igbdata.shiptypeid).typeName if igbdata.shiptypeid else "None"))
        session.shipid = igbdata.shipid
        session.shiptypeid = igbdata.shiptypeid
    return ret

# *****************************************

def GetUserInfo():
    txt = "Logged in as <b>%s</b> &middot; <a href=\"logout\">Log out</a>" % session.username
    if igbdata.charid:
        txt += """<br>Ingame as <span class=link OnClick="CCPEVE.showInfo('%s', '%s');">%s</span> flying <span class=link OnClick="CCPEVE.showInfo('%s', '%s');">%s</span> in <span class=link OnClick="CCPEVE.showInfo('5', '%s');">%s</span>
        """ % (util.typeCharacterDeteis, igbdata.charid, evenames.Get(igbdata.charid), igbdata.shiptypeid, igbdata.shipid, igbdata.shipname, igbdata.solarsystemid, invsolarsystems.Get(igbdata.solarsystemid)[0])
    else:
        txt += "<br>(Not running in a trusted IGB session)"
    return txt

def GetAPIDom(page, userID, apiKey, charID=None, arg=None):
    url = "%s%s?userID=%s&apiKey=%s&characterID=%s" % (API_URL, page, userID, apiKey, charID)
    if arg:
        url += "&%s" % arg
    print "GetAPIData", url
    dom = minidom.parse(urllib2.urlopen(url))
    return dom
    
def GetAPIData(page, userID, apiKey, charID=None, arg=None):
    rows = cache.ram("GetAPIData %s %s %s %s %s" % (page, userID, apiKey, charID, arg), lambda:DoGetAPIData(page, userID, apiKey, charID, arg),time_expire=CACHE_TIME)
    return rows

def DoGetAPIData(page, userID, apiKey, charID=None, arg=None):
    dom = GetAPIDom(page, userID, apiKey, charID, arg)
    rows = dom.getElementsByTagName("row")
    return rows

class Item(object):
    def __init__(self, itemID, locationID, typeID, quantity, flag, singleton, ownerID):
        self.itemID     = itemID
        self.locationID = locationID
        self.typeID     = typeID
        self.flag       = flag
        self.quantity   = quantity
        self.singleton  = singleton
        self.ownerID    = ownerID
        self.children   = {}
        self.solarSystemID, self.constellationID, self.regionID, self.stationTypeID = invstations.Get(locationID)

    def AddChild(self, childItem):
        self.children[childItem.itemID] = childItem

    def __getattr__(self,method):
        if method in self.__dict__:
            return self.__dict__[method]
        if method.startswith('__'):
            raise AttributeError(method)
        t = invtypes.Get(self.typeID)
        return getattr(t, method, "Unknown")
        
    def __repr__(self, *args):
        txt = "Inventory item <b>%s</b>, locationID=%s, typeID=%s, flag=%s, quantity=%s, singleton=%s" % (self.itemID, self.locationID, self.typeID, self.flag, self.quantity, self.singleton)
        if len(self.children):
            txt += ", containing %s children" % (len(self.children))
        return txt

def GetStationInfo(stationID):
    return cache.ram("GetStationInfo %s" % stationID, lambda:DoGetStationInfo(stationID), None)
    
def DoGetStationInfo(stationID):
    if stationID is None:
        return None, None, None
    print "Getting station info from DB", stationID
    sql = "SELECT solarSystemID, constellationID, regionID FROM staStations WHERE stationID = %d" % stationID
    rows = db.executesql(sql)
    try:
        return rows[0].solarSystemID, rows[0].constellationID, rows[0].regionID
    except:
        return None, None, None

def GetExpirationFromDom(dom):
    currTime = dom.getElementsByTagName("currentTime")[0].childNodes[0].nodeValue
    cachedUntil = dom.getElementsByTagName("cachedUntil")[0].childNodes[0].nodeValue
    currTime = datetime.datetime.strptime(currTime, '%Y-%m-%d %H:%M:%S')
    cachedUntil = datetime.datetime.strptime(cachedUntil, '%Y-%m-%d %H:%M:%S')
    return currTime, cachedUntil

def GetAssetsForChar(userID, apiKey, charID, force=False):
    #print "GetAssetsForChar", userID, charID
    if not os.path.exists(ASSETS_FOLDER):
        os.makedirs(ASSETS_FOLDER)

    fileName = "%s%s.xml" % (ASSETS_FOLDER, charID)
    dom = None
    try:
        f = open(fileName, "r")
        dom = minidom.parse(f)
        f.close()

    except:
        dom = None

    items = {}

    if not dom or force:
        page = "char/AssetList.xml.aspx"
        url = "%s%s?userID=%s&apiKey=%s&characterID=%s" % (API_URL, page, userID, apiKey, charID)
        xml = urllib2.urlopen(url).read()
        if "security" in xml:
            raise Exception("user/char %d/%d does not have the proper FULL API key" % (userID, charID))
        if "error" in xml:
            raise Exception("XML for %s screwed" % url)
        f = open(fileName, "w")
        f.write(xml)
        f.close()

        dom = GetAPIDom("char/AssetList.xml.aspx", userID, apiKey, charID)

    currTime, cachedUntil = GetExpirationFromDom(dom)

    def CollectStuff(c):
        itemID      = long(c.getAttribute("itemID"))
        typeID      = int(c.getAttribute("typeID"))
        quantity    = int(c.getAttribute("quantity"))
        flag        = int(c.getAttribute("flag"))
        singleton   = int(c.getAttribute("singleton"))
        locationID  = None
        try:
            locationID   = long(c.getAttribute("locationID"))
        except:
            pass

        return itemID, typeID, quantity, flag, singleton, locationID

    topNode = dom.getElementsByTagName("result")[0]
    for node in topNode.childNodes:
        if node.nodeType == node.TEXT_NODE:
            continue
        #print node.tagName, node.nodeType, node.attributes, len(node.childNodes)
        for chld in node.childNodes:
            if chld.nodeType == node.TEXT_NODE:
                continue
            itemID, typeID, quantity, flag, singleton, locationID = CollectStuff(chld)
            parentID = itemID

            if locationID not in items:
                solarSystemID, constellationID, regionID, stationTypeID = invstations.Get(locationID)
                items[locationID] = Item(locationID, solarSystemID, None, None, None, None, None)

            item = Item(itemID, locationID, typeID, quantity, flag, singleton, charID)
            items[locationID].AddChild(item)

            childNodes = chld.getElementsByTagName("rowset")
            if childNodes:
                childNodes = childNodes[0].childNodes
            children = []
            for c in childNodes:
                if c.nodeType == node.TEXT_NODE:
                    continue
                itemID, typeID, quantity, flag, singleton, dummy = CollectStuff(c)
                item = Item(itemID, parentID, typeID, quantity, flag, singleton, charID)
                items[locationID].children[parentID].AddChild(item)

                childNodes = c.getElementsByTagName("rowset")
                if childNodes:
                    childNodes = childNodes[0].childNodes
                children = []
                for c2 in childNodes:
                    if c2.nodeType == node.TEXT_NODE:
                        continue
                    itemID2, typeID, quantity, flag, singleton, dummy = CollectStuff(c2)
                    item = Item(itemID2, itemID, typeID, quantity, flag, singleton, charID)
                    items[locationID].children[parentID].children[itemID].AddChild(item)

    return items, cachedUntil

def GetItemsTxt():
    items = {}
    oldestCachedUntil = None
    if session.eveCharacters:
        for char in session.eveCharacters:
            apiKey = char["apiKey"]
            userID = char["userID"]
            charID = char["charID"]
            try:
                i, cachedUntil = cache.ram("assetsforchar %s" % charID, lambda:GetAssetsForChar(userID, apiKey, charID), time_expire=CACHE_TIME)
            except:
                raise
            if oldestCachedUntil is None or cachedUntil < oldestCachedUntil:
                oldestCachedUntil = cachedUntil
            for k, v in i.iteritems():
                if k not in items:
                    items[k] = v
                else:
                    for itemID, item in v.children.iteritems():
                        items[k].children[itemID] = item
    skipTypeIDs = []
    evenames.Prime(items.keys())
    numItems = 0
    itemsTxt = ""
    ignoreTypes = [int(a) for a in (session.assetFilters.get("type_ignore", "") or "").split(",") if a]
    ignoreGroups = [int(a) for a in (session.assetFilters.get("group_ignore", "") or "").split(",") if a]
    ignoreCategories = [int(a) for a in (session.assetFilters.get("category_ignore", "") or "").split(",") if a]
    ignoreLocationIDs = [int(a) for a in (session.assetFilters.get("location_ignore", "") or "").split(",") if a]
    
    # start by sorting the stations
    stations = []
    for topID, topItem in items.iteritems():
        stations.append((evenames.Get(topID), topID, topItem))
    flt = session.assetFilters.get("filter", "") or ""
    stations.sort()
    allSolarSystemIDs = set()
    for topName, topID, topItem in stations:
        allSolarSystemIDs.add(topItem.locationID or 0)
    mySolarSystemID = igbdata.solarSystemID or 0
    invsolarsystems.PrimeJumps(mySolarSystemID, allSolarSystemIDs)

    def IsIgnored(item):
        if ignoreTypes and item.typeID in ignoreTypes:
            return True
        if ignoreCategories and item.categoryID in ignoreCategories:
            return True
        if ignoreGroups and item.groupID in ignoreGroups:
            return True
        if topID in ignoreLocationIDs:
            return True
        if item.typeID in skipTypeIDs:
            return True
        return False

    def IsWanted(item):
        if item.locationID < util.minPlayerItem:
            solarSystemID = int(session.assetFilters.get("solarsystem") or 0)
            if solarSystemID:
                if util.IsStation(solarSystemID):
                    solarSystemID = invstations.Get(solarSystemID)[0]
                if not item.solarSystemID or int(item.solarSystemID) != solarSystemID:
                    return False
            constellationID = int(session.assetFilters.get("constellation") or 0)
            if constellationID:
                if util.IsStation(constellationID):
                    constellationID = invstations.Get(int(session.assetFilters["constellation"]))[1]
                if not item.constellationID or int(item.constellationID) != constellationID:
                    return False
            try:
                regionID = int(session.assetFilters.get("region") or 0)
            except:
                regionID = 0
            if regionID:
                if util.IsStation(regionID):
                    regionID = invstations.Get(regionID)[2]
                if not item.regionID or int(item.regionID) != regionID:
                    return False
            ownerName = evenames.Get(item.ownerID)
            if session.assetFilters.get("owner") and not ownerName.lower().startswith(session.assetFilters.get("owner")):
                return False

        if IsIgnored(item):
            return False

        # for the rest lets go through children as well and show the top item if the child should be shown
        if session.assetFilters.get("meta") and not item.metaName.lower() == session.assetFilters.get("meta").lower():
            return False
        if session.assetFilters.get("category") and item.categoryID != int(session.assetFilters.get("category") or 0):
            return False
        if session.assetFilters.get("group") and item.groupID != int(session.assetFilters.get("group") or 0):
            return False
        if session.assetFilters.get("type") and item.typeID != int(session.assetFilters.get("type") or 0):
            return False
        return True

    totalWorth = 0
    allItems = []
    sortBy = int(request.vars.sortBy) if request.vars.sortBy else 0
    groupByStations = int(session.groupByStations or 0)
    expandContainers = int(session.expandContainers or 0)
    if not groupByStations:
        allItems.append([0, 0, "", []])
    for topName, topID, topItem in stations:
        jumps = invsolarsystems.GetJumps(mySolarSystemID, topItem.locationID or 0)
        n = 0
        solarSystem = invsolarsystems.Get(topItem.locationID)
        stationTypeID = invstations.Get(topID)[3]

        t = "AddHeader(%d, '%s &ndash; %d items &ndash; %s jumps', %s, %.2f, %s);\n" % (int(topID), evenames.Get(topID).replace("'", "\\'"), n, jumps, int(topItem.locationID or 0), float(solarSystem[3] or 0.0), stationTypeID or 0)
        if groupByStations:
            allItems.append([0, evenames.Get(topID), t, []])
        itemsInThisStation = []
        allOwners = {}
        for item in topItem.children.itervalues():
            ownerName = evenames.Get(item.ownerID)
            locationName = evenames.Get(item.locationID)
            locationName = evenames.Get(topItem.locationID or item.locationID)
            if not IsWanted(item):
                continue

            parentWanted = True
            if flt and flt not in item.typeName.lower() and flt not in item.groupName.lower() and flt not in item.categoryName.lower():
                parentWanted = False

            numItems += 1
            catName = "<a href=\"?category=%s\">%s</a>" % (item.categoryName, item.categoryName)
            itemsInThisContainer = []
            w = (item.price or 0) * item.quantity
            totalWorth += w
            sorts = [item.typeName, item.quantity, item.groupName, item.categoryName, item.metaGroup or item.techLevel, ownerName, w, locationName, jumps]
            if ownerName not in allOwners:
                allOwners[ownerName] = max(allOwners.values() or [0])+1
            t = "AddItem(%s, %s, %s, %s, %s, '%s', '%s', %d, %.0f, %d);\n" % (item.itemID, item.typeID, item.quantity, item.locationID, topItem.locationID or 0, ownerName, locationName, len(item.children), w, jumps)
            p = [sorts[sortBy], item.typeName, t, []]
            #
            parentName = item.typeName

            for item in item.children.itervalues():
                if IsIgnored(item):
                    continue
                if flt and flt not in item.typeName.lower() and flt not in item.groupName.lower() and flt not in item.categoryName.lower():
                    continue
                numItems += 1
                w = (item.price or 0) * item.quantity
                totalWorth += w
                sorts = [item.typeName, item.quantity, item.groupName, item.categoryName, item.metaGroup or item.techLevel, ownerName, w, locationName, jumps]
                if ownerName not in allOwners:
                    allOwners[ownerName] = max(allOwners.values() or [0])+1

                t = "AddItem(%s, %s, %s, %s, %s, '%s', '%s', %d, %.0f, %d);\n" % (item.itemID, item.typeID, item.quantity, item.locationID, topItem.locationID or 0, ownerName, locationName, len(item.children), w, jumps)
                itemsInThisContainer.append([sorts[sortBy], parentName+"1 "+item.typeName, t, []])
                for item2 in item.children.itervalues():
                    if IsIgnored(item2):
                        continue
                    numItems += 1
                    w = (item2.price or 0) * item2.quantity
                    totalWorth += w
                    sorts = [item2.typeName, item2.quantity, item2.groupName, item2.categoryName, item2.metaName, ownerName, w, locationName, jumps]
                    t = "AddItem(%s, %s, %s, %s, '%s', '%s', %d, %.1f, %d);\n" % (item2.itemID, item2.typeID, item2.quantity, item2.locationID, ownerName, locationName, len(item2.children), w, jumps)
                    itemsInThisContainer.append([sorts[sortBy], parentName+"2 "+item2.typeName, t, []])
            if parentWanted or itemsInThisContainer:
                allItems[-1][-1].append(p)
                p[-1] = itemsInThisContainer

        if itemsInThisStation:
            pass
    allItems.sort()

    for p in allItems:
        if p[-1]:
            itemsTxt += p[2]
        p[-1].sort()
        if int(request.vars.sortDir or 0):
            p[-1].reverse()
        for pp in p[-1]:
            pp[-1].sort()
            if int(request.vars.sortDir or 0):
                pp[-1].reverse()
            itemsTxt += pp[2]
            if expandContainers:
                for ppp in pp[-1]:
                    itemsTxt += ppp[2]

    itemsTxt += "AddSummary('Found %s items worth %.0f million ISK');" % (numItems, totalWorth/1000000)
    filters = set()
    log.LogInfo(session.assetFilters)
    for k, v in session.assetFilters.iteritems():
        if v:
            k = k.replace("solarsystem", "location").replace("constellation", "location").replace("region", "location")
            if "_ignore" in k:
                k = "ignore"
            filters.add(k)
        
    filtersTxt = ""
    for k in filters:
        filtersTxt += "'%s', " % k
    itemsTxt += "\nWriteFilterLinks([%s]);\n" % filtersTxt[:-2]
    itemsTxt += ""
    return itemsTxt, numItems, int(totalWorth/1000000), oldestCachedUntil


def PersistAssetFilter(filterType, filterVal):
    filterType = filterType.replace("'", "''")
    filterVal = filterVal.replace("'", "''") if filterVal else None
    sql = "DELETE FROM _assetFilters WHERE userID = %d AND filterType LIKE '%%%s'" % (session.userid, filterType)
    log.LogSQL(sql)
    db.executesql(sql)
    if filterVal:
        sql = "INSERT INTO _assetFilters (userID, filterType, filterVal) VALUES (%d, '%s', '%s')" % (session.userid, filterType, filterVal)
        log.LogSQL(sql)
        db.executesql(sql)

def SetupUserSession(userID, userName):
    session.userid = userID
    session.username = userName

    sql = "SELECT * FROM _eveUsers WHERE userID = %d" % userID
    rows = db.executesql(sql)
    session.eveUsers = {}
    for r in rows:
        eveUserID = r.eveUserID
        apiKey = r.apiKey
        session.eveUsers[eveUserID] = apiKey

    #PopulateMyCharacters()
    session.eveCharacters = []

    sql = "SELECT * FROM _eveCharacters WHERE userID = %d" % userID
    rows = db.executesql(sql)
    for r in rows:
        c = {
            "charID"      : r.charID,
            "charName"    : r.charName,
            "corpID"      : r.corpID,
            "corpName"    : r.corpName,
            "userID"      : r.eveUserID,
            "apiKey"      : session.eveUsers.get(r.eveUserID, None),
        }
        session.eveCharacters.append(c)

    sql = "SELECT * FROM _assetFilters WHERE userID = %d" % session.userid
    log.LogSQL(sql)
    rows = db.executesql(sql)
    session.assetFilters = {}
    for r in rows:
        log.LogInfo("setting assetfilter", r)
        session.assetFilters[r.filterType] = r.filterVal
    
def PopulateMyCharacters():
    """
    Refresh local storage of characters from the API and refresh our name cache while we're at it
    """
    sql = "DELETE FROM _eveCharacters WHERE userID = %d" % session.userid
    db.executesql(sql)

    for userID, apiKey in session.eveUsers.iteritems():
        try:
            rows = GetAPIData("account/Characters.xml.aspx", userID, apiKey)
        except Exception, e:
            print "Error populating characters for %s: %s" % (userID, e)
            continue
        characters = []
        for r in rows:
            charID = int(r.getAttribute("characterID"))
            charName = r.getAttribute("name")
            corpID = int(r.getAttribute("corporationID"))
            corpName = r.getAttribute("corporationName")
            sql = "INSERT INTO _eveCharacters (userID, eveUserID, charID, charName, corpID, corpName) VALUES (%d, %d, %d, '%s', %d, '%s')" % (session.userid, userID, charID, charName, corpID, corpName)
            db.executesql(sql)
            sql = "DELETE FROM eveNames WHERE itemID IN (%d, %d)" % (charID, corpID)
            db.executesql(sql)
            sql = "INSERT INTO eveNames (itemID, itemName) VALUES (%d, '%s')" % (charID, charName.replace("'", "''"))
            db.executesql(sql)
            sql = "INSERT INTO eveNames (itemID, itemName) VALUES (%d, '%s')" % (corpID, corpName.replace("'", "''"))
            db.executesql(sql)

def user():
    """
    exposes:
    http://..../[app]/default/user/login
    http://..../[app]/default/user/logout
    http://..../[app]/default/user/register
    http://..../[app]/default/user/profile
    http://..../[app]/default/user/retrieve_password
    http://..../[app]/default/user/change_password
    use @auth.requires_login()
        @auth.requires_membership('group name')
        @auth.requires_permission('read','table name',record_id)
    to decorate functions that need access control
    """
    return dict(form=auth())


def download():
    """
    allows downloading of uploaded files
    http://..../[app]/default/download/[filename]
    """
    return response.download(request,db)


def call():
    """
    exposes services. for example:
    http://..../[app]/default/call/jsonrpc
    decorate with @services.jsonrpc the functions to expose
    supports xml, json, xmlrpc, jsonrpc, amfrpc, rss, csv
    """
    #session.forget()
    return service()
