util = local_import("util", reload=True)
log = local_import("log", reload=True)

CACHE_TIME = 30 * 60
CACHE_TIME_LONG = 7 * 1440 * 60
API_URL         = "http://api.eveonline.com/"
#API_URL         = "http://apitest.eveonline.com/"
MARKETDATA_URL  = "http://eve-marketdata.com/"

# DATABASE
db = DAL('mssql://USERNAME:PASSWORD@DATABASE SERVER/DATABASE')

from gluon.tools import *
mail = Mail()                                  # mailer
auth = Auth(globals(),db)                      # authentication/authorization
crud = Crud(globals(),db)                      # for CRUD helpers using auth
service = Service(globals())                   # for json, xml, jsonrpc, xmlrpc, amfrpc
plugins = PluginManager()

mail.settings.server = 'logging' or 'smtp.gmail.com:587'  # your SMTP server
mail.settings.sender = 'you@gmail.com'         # your email
mail.settings.login = 'username:password'      # your credentials or None

class InvTypes():
    def __init__(self, *args):
        self.types = cache.ram('invtypes', lambda:self.PrimeTypes(), time_expire=None)

    def PrimeTypes(self):
        log.LogInfo("Priming types...")
        sql = """
SELECT t.typeID, t.typeName, t.description, t.basePrice, t.portionSize, t.published,
       g.groupID, g.groupName, c.categoryID, c.categoryName,
       CASE WHEN NOT techLevel.valueInt IS NULL THEN techLevel.valueInt ELSE techLevel.valueFloat END AS TECH_LEVEL,
       CASE WHEN NOT metaGroupID.valueInt IS NULL THEN metaGroupID.valueInt ELSE metaGroupID.valueFloat END AS META_GROUP,
        p.price
  FROM invTypes t
    INNER JOIN invGroups g ON g.groupID = t.groupID
      INNER JOIN invCategories c ON c.categoryID = g.categoryID
    LEFT JOIN dgmTypeAttributes techLevel ON techLevel.typeID = t.typeID AND techLevel.attributeID = %s
    LEFT JOIN dgmTypeAttributes metaGroupID ON metaGroupID.typeID = t.typeID AND metaGroupID.attributeID = %s
    LEFT JOIN _typePrices p ON p.typeID = t.typeID
        """ % (util.attributeTechLevel, util.attributeMetaGroupID)
        log.LogSQL(sql)
        rows = db.executesql(sql)
        types = {}

        for row in rows:
            techLevel = int(row.TECH_LEVEL) if row.TECH_LEVEL else 1
            metaGroup = int(row.META_GROUP) if row.META_GROUP else 0
            metaName = util.metaNames.get(metaGroup, None)
            metaNameID = metaGroup
            if not metaName:
                metaName = util.metaNames.get(-techLevel, "Tech I")
                metaNameID = -techLevel

            t = util.KeyVal(
                    typeID          = row.typeID,
                    typeName        = row.typeName,
                    description     = row.description,
                    basePrice       = row.basePrice,
                    portionSize     = row.portionSize,
                    groupID         = row.groupID,
                    groupName       = row.groupName,
                    categoryID      = row.categoryID,
                    categoryName    = row.categoryName,
                    techLevel       = techLevel,
                    metaGroup       = metaGroup,
                    metaName        = metaName,
                    metaNameID      = metaNameID,
                    price           = row.price,
                    published       = row.published,
                    )
            types[row.typeID] = t
        log.LogInfo("Done priming %s types" % len(types))
        return types

    def Get(self, typeID):
        return self.types.get(typeID, None)

    def GetPrice(self, typeID):
        t = self.types.get(typeID, None)
        return t.price if t else -1

class EveNames():
    def PrimeTypicalNames(self):
        # prime all solarsystems and station names since those will be often asked for
        sql = """SELECT itemID, itemName 
                   FROM eveNames 
                  WHERE itemID BETWEEN %s AND %s OR itemID BETWEEN %s AND %s""" % (
                util.minSolarSystem, 
                util.maxSolarSystem, 
                util.minStation, 
                util.maxStation
                )
        log.LogSQL(sql)
        rows = db.executesql(sql)
        names = {}
        for row in rows:
            names[row.itemID] = row.itemName

        log.LogInfo("%s names primed" % len(names))
        
        return names

    def __init__(self, *args):
        self.names = cache.ram('evenames', lambda:self.PrimeTypicalNames(), time_expire=None)

    def GetNameFromAPI(self, ownerID):
        log.LogInfo(ownerID, "not found in cache. Going to API")
        url = "%seve/CharacterName.xml.aspx?ids=%s" % (API_URL, ownerID)
        try:
            dom = minidom.parse(urllib2.urlopen(url))
            
            row = dom.getElementsByTagName("row")[0]
            name = row.getAttribute("name")
            sql = "INSERT INTO eveNames (itemID, itemName) VALUES (%d, '%s')" % (ownerID, name.replace("'", "''"))
            log.LogSQL(sql)
            db.executesql(sql)
            return name
        except Exception, e:
            log.LogError("Error in GetNameFromAPI %s" % ownerID)
            return "ERROR: %s" % ownerID

    def GetNameFromDB(self, ownerID):
        if ownerID is None:
            return None
        log.LogInfo(ownerID, "not found in cache. Going to DB")
        sql = "SELECT itemName FROM eveNames WHERE itemID = %d" % ownerID
        log.LogSQL(sql)
        rows = db.executesql(sql)
        if rows:
            return rows[0].itemName

        return None

    def Get(self, ownerID):
        try:
            return self.names[ownerID]
        except:
            name = self.GetNameFromDB(ownerID)
            if not name:
                name = self.GetNameFromAPI(ownerID)
            self.names[ownerID] = name
            return name

    def Prime(self, ownerIDs):
        missingOwnerIDs = []
        for ownerID in ownerIDs:
            if ownerID not in self.names:
                missingOwnerIDs.append(ownerID)
        if missingOwnerIDs:
            log.LogInfo("Need to fetch %s names" % len(missingOwnerIDs))
            ownerIDTxt = ",".join([str(a) for a in missingOwnerIDs])
            url = "%seve/CharacterName.xml.aspx?ids=%s" % (API_URL, ownerIDTxt)
            try:
                dom = minidom.parse(urllib2.urlopen(url))
                rows = dom.getElementsByTagName("row")
                for row in rows:
                    ownerID = int(row.getAttribute("characterID"))
                    name = row.getAttribute("name")
                    self.names[ownerID] = name
            except:
                self.names[ownerID] = "ERROR: %s" % ownerID

class InvStations():
    def PrimeStations(self):
        sql = "SELECT stationID, solarSystemID, constellationID, regionID, stationTypeID FROM staStations"
        log.LogSQL(sql)
        rows = db.executesql(sql)
        stations = {}
        for row in rows:
            stations[row.stationID] = [row.solarSystemID, row.constellationID, row.regionID, row.stationTypeID]
        self.stations = stations
        log.LogInfo("%s stations primed" % len(self.stations))
        return stations

    def __init__(self, *args):
        self.stations = cache.ram('invstations', lambda:self.PrimeStations(), time_expire=None)

    def Get(self, stationID):
        try:
            s = self.stations[stationID]
            return s[0], s[1], s[2], s[3]
        except:
            return None, None, None, None


class InvSolarSystems():
    def PrimeSolarSystems(self):
        sql = "SELECT solarSystemID, solarSystemName, constellationID, regionID, security FROM mapSolarSystems"
        log.LogSQL(sql)
        rows = db.executesql(sql)
        solarSystems = {}
        for row in rows:
            solarSystems[row.solarSystemID] = [row.solarSystemName, row.constellationID, row.regionID, row.security]
        self.solarSystems = solarSystems
        log.LogInfo("%s solar systems primed" % len(self.solarSystems))
        return solarSystems

    def EmptyDict(self):
        return {}

    def __init__(self, *args):
        self.solarSystems = cache.ram('invsolarsystems', lambda:self.PrimeSolarSystems(), time_expire=None)
        self.jumps = cache.ram('invsolarsystems_jumps', lambda:self.EmptyDict(), time_expire=None)

    def Get(self, solarSystemID):
        try:
            s = self.solarSystems[solarSystemID]
            return s[0], s[1], s[2], s[3]
        except:
            return None, None, None, None

    def PrimeJumps(self, fromSolarSystemID, toSolarSystemIDs):
        prunedToSolarSystemIDs = []
        for i in toSolarSystemIDs:
            keySorted = sorted([fromSolarSystemID, i])
            keySorted = (keySorted[0], keySorted[1])
            if keySorted not in self.jumps:
                prunedToSolarSystemIDs.append(i)

        if not prunedToSolarSystemIDs:
            return

        toIdsTxt = ",".join([str(i) for i in prunedToSolarSystemIDs])

        sql = "SELECT fromID, toID, jumpsShortest FROM _jumps WHERE fromID = %d AND toID IN (%s) ORDER BY toID" % (fromSolarSystemID, toIdsTxt)
        log.LogSQL(sql)
        rows = db.executesql(sql)
        for row in rows:
            keySorted = sorted([row.fromID, row.toID])
            keySorted = (keySorted[0], keySorted[1])
            self.jumps[keySorted] = row.jumpsShortest
        log.LogInfo("primed %s jumps out of %s requests" % (len(rows), len(toSolarSystemIDs)))

    def GetJumps(self, solarSystemID1, solarSystemID2):
        ids = sorted([solarSystemID1, solarSystemID2])
        ids = (ids[0], ids[1])
        try:
            return self.jumps[ids]
        except:
            sql = "SELECT jumpsShortest FROM _jumps WHERE fromID = %d AND toID = %d" % (ids[0], ids[1])
            log.LogSQL(sql)
            jumps = -1
            try:
                row = db.executesql(sql)[0]
                jumps = row.jumpsShortest
            except:
                pass
            self.jumps[ids] = int(jumps)
        return self.jumps[ids]

class IGBData():
    def __getattr__(self, method):
        varName = varValue = None
        for k, v in request.env.iteritems():
            if k.lower().startswith("http_eve"):
                varName = k[9:].lower()
                if varName == method.lower():
                    varValue = v
                    if "id" in varName:
                        varValue = int(varValue)

        return varValue

    def DumpAll(self):
        for k, v in request.env.iteritems():
            if k.lower().startswith("http_eve"):
                log.LogInfo(k, v)

invtypes = InvTypes()
evenames = EveNames()
invstations = InvStations()
invsolarsystems = InvSolarSystems()
igbdata = IGBData()