# Min/Max itemID constants
minFaction = 500000
maxFaction = 599999
minNPCCorporation = 1000000
maxNPCCorporation = 1999999
minAgent = 3000000
maxAgent = 3999999
minRegion = 10000000
maxRegion = 19999999
minConstellation = 20000000
maxConstellation = 29999999
minSolarSystem = 30000000
maxSolarSystem = 39999999
minValidLocation = 30000000
minValidShipLocation = 30000000
minUniverseCelestial = 40000000
maxUniverseCelestial = 49999999
minStargate = 50000000
maxStargate = 59999999
minStation = 60000000
maxStation = 69999999
minValidCharLocation = 60000000
minUniverseAsteroid = 70000000
maxUniverseAsteroid = 79999999
minPlayerItem = 100000000
maxNonCapitalModuleSize = 500
mapWormholeRegionMin = 11000000
mapWormholeRegionMax = 11999999
mapWormholeConstellationMin = 21000000
mapWormholeConstellationMax = 21999999
mapWormholeSystemMin = 31000000
mapWormholeSystemMax = 31999999
minPlayerOwner = 90000000
maxPlayerOwner = 2147483647
minFakeItem = 9000000000000000000

# Contracts
conAvailMyAlliance = 3
conAvailMyCorp     = 2
conAvailMyself     = 1
conAvailPublic     = 0

conStatusOutstanding = 0
conStatusInProgress = 1
conStatusFinishedIssuer = 2
conStatusFinishedContractor = 3
conStatusFinished = 4
conStatusCancelled = 5
conStatusRejected = 6
conStatusFailed = 7
conStatusDeleted = 8
conStatusReversed = 9

conTypeNothing = 0
conTypeItemExchange = 1
conTypeAuction = 2
conTypeCourier = 3
conTypeLoan = 4

# Inventory constants - categories
categoryAbstract = 29
categoryAccessories = 5
categoryAncientRelic = 34
categoryAsteroid = 25
categoryWorldSpace = 26
categoryBlueprint = 9
categoryBonus = 14
categoryCelestial = 2
categoryCharge = 8
categoryCommodity = 17
categoryDecryptors = 35
categoryDeployable = 22
categoryDrone = 18
categoryEntity = 11
categoryImplant = 20
categoryMaterial = 4
categoryModule = 7
categoryOwner = 1
categoryPlaceables = 27
categoryPlanetaryCommodities = 43
categoryPlanetaryInteraction = 41
categoryPlanetaryResources = 42
categoryReaction = 24
categoryShip = 6
categorySkill = 16
categorySovereigntyStructure = 40
categoryStation = 3
categoryStructure = 23
categoryStructureUpgrade = 39
categorySubSystem = 32
categorySystem = 0
categoryTrading = 10

# Inventory constants - groups
groupCargoContainer = 12
groupSecureCargoContainer = 340
groupAuditLogSecureContainer = 448
groupFreightContainer = 649
groupConstellation = 4
groupRegion = 3
groupSolarSystem = 5
groupMissionContainer = 952

# Inventory constants - types
typeCharacterAchura     = 1383
typeCharacterAmarr      = 1373
typeCharacterBrutor     = 1380
typeCharacterCivire     = 1375
typeCharacterDeteis     = 1376
typeCharacterGallente   = 1377
typeCharacterIntaki     = 1378
typeCharacterJinMei     = 1384
typeCharacterKhanid     = 1385
typeCharacterModifier   = 1382
typeCharacterNiKunni    = 1374
typeCharacterSebiestor  = 1379
typeCharacterStatic     = 1381
typeCharacterVherokior  = 1386

# known containers
containerCategories = (
    categoryStation,
    categoryShip,
    categoryTrading,
    categoryStructure,
    )

containerGroups = (
    groupCargoContainer,
    groupSecureCargoContainer,
    groupAuditLogSecureContainer,
    groupFreightContainer,
    groupConstellation,
    groupRegion,
    groupSolarSystem,
    groupMissionContainer,
    )

# dogma attributes
attributeTechLevel              = 422
attributeMetaGroupID            = 1692
attributeMetaLevel              = 633
attributeLowSlots               = 12
attributeMedSlots               = 13
attributeHiSlots                = 14
attributeRequiredSkill1         = 182
attributeRequiredSkill1Level    = 277
attributeRequiredSkill2         = 183
attributeRequiredSkill2Level    = 278
attributeRequiredSkill3         = 184
attributeRequiredSkill3Level    = 279
attributeRequiredSkill4         = 1285
attributeRequiredSkill4Level    = 1286
attributeRequiredSkill5         = 1289
attributeRequiredSkill5Level    = 1287
attributeRequiredSkill6         = 1290
attributeRequiredSkill6Level    = 1288
attributeResearchPointCost      = 1155

metaNames = {
    -2 : "Tech II",
    -3 : "Tech III",
    -1 : "Tech I",
    3 : "Storyline",
    4 : "Faction",
    5 : "Officer",
    6 : "Deadspace",
}

def IsContainer(categoryID, groupID):
    return categoryID in containerCategories or groupID in containerGroups

def IsRegion(itemID):
    return (itemID >= minRegion) and (itemID < maxRegion)

def IsConstellation(itemID):
    return (itemID >= minConstellation) and (itemID < maxConstellation)

def IsSolarSystem(itemID):
    return (itemID >= minSolarSystem) and (itemID < maxSolarSystem)

def IsCelestial(itemID):
    return (itemID >= minUniverseCelestial) and (itemID < maxUniverseCelestial)

def IsWormholeSystem(itemID):
    return (itemID >= mapWormholeSystemMin) and (itemID < mapWormholeSystemMax)
    
def IsWormholeConstellation(constellationID):
    return (constellationID >= mapWormholeConstellationMin) and (constellationID < mapWormholeConstellationMax)
    
def IsWormholeRegion(regionID):
    return (regionID >= mapWormholeRegionMin) and (regionID < mapWormholeRegionMax)

def IsUniverseCelestial(itemID):
    return (itemID >= minUniverseCelestial) and (itemID <= maxUniverseCelestial)

def IsStargate(itemID):
    return (itemID >= minStargate) and (itemID < maxStargate)

def IsStation(itemID):
    return (itemID >= minStation) and (itemID < maxStation)

def IsOutpost(itemID):
    return (itemID >= 61000000) and (itemID < 64000000)

def IsTrading(itemID):
    return (itemID >= 64000000) and (itemID < 66000000)

def IsOfficeFolder(itemID):
    return (itemID >= 66000000) and (itemID < 68000000)

def IsFactoryFolder(itemID):
    return (itemID >= 68000000) and (itemID < 70000000)

def IsUniverseAsteroid(itemID):
    return (itemID >= minUniverseAsteroid) and (itemID < maxUniverseAsteroid)

def IsPlayerItem(itemID):
    return (itemID >= minPlayerItem and itemID < minFakeItem)

class KeyVal:

    __guid__ = "util.KeyVal"
    __passbyvalue__ = 1

    def __init__(self, dictLikeObject=None, **kw):
        self.__dict__ = kw
        if dictLikeObject is not None:
            if isinstance(dictLikeObject, dict):
                self.__dict__.update(dictLikeObject)
            elif isinstance(dictLikeObject, blue.DBRow):
                for k in dictLikeObject.__keys__:
                    self.__dict__[k] = getattr(dictLikeObject, k)
            else:
                raise TypeError("%s can only be initialized with dictionaries, key/value pairs or blue.DBRow's. %s isn't one of them." % (self.__guid__, type(dictLikeObject)))
            

    def __str__(self):
        members = dict(filter(lambda (k, v): not k.startswith("__"), self.__dict__.items()))
        return "%s %s: %s" % (self.__doc__ or "Anonymous", self.__class__.__name__, members)

    def __repr__(self):
        return "<%s>" % str(self)

    def copy(self):
        ret = KeyVal()
        ret.__dict__.update(self.__dict__)
        return ret

    def get(self, key, defval=None):
        return self.__dict__.get(key, defval)

    def Get(self, key, defval=None):
        return self.__dict__.get(key, defval)

    def Set(self, key, value):
        self.__dict__[key] = value 