
//On Document Ready
$(function() {
    BuildTable(0);
    var endDate = new Date();
    $(".waypointsLink").click(function() {
        if (!checkEVEBrowser())
            return;
        var waypoints = $(this).attr("rel");
        SetMultiWaypoints(waypoints);
    });

    if (IsEVEBrower()) {
    	var url = 'http://'+window.location.hostname+'/*';
        CCPEVE.requestTrust(url);
    }
    $(".station tr").live("mouseover", function() {
        $(this).addClass("over");
    }).live("mouseout", function() {
        $(this).removeClass("over");
    });
    $(".zebra tr").live("mouseover", function(){
        $(this).addClass("over");
    }).live("mouseout", function(){$(this).removeClass("over");});

    $(".zebra tr:even").addClass("even");
    $(".zebra tr:odd").addClass("odd");

    $(".zebra tr").mouseover(function(){$(this).addClass("over");}).mouseout(function(){$(this).removeClass("over");});

    bindAgentMenu();

    $("#researchTable").tableFilter();
    setTimeout('CheckSession()', 10000);
});

function FilterText() {
    FilterAssets("filter", $("#filter").val());
}
var startDate = new Date();
var tableRows = [];

function loading() {
    $('#loading')
        .css("left", $(window).width()/2-$('#loading').width()/2+"px")
        .show();
}

function FilterAssets(which, what) {
    loading();
    if (what == undefined) {
        alert("what is undefined for " + which);
    	return;
    }
    if (isNaN(what) && what != null) what = what.toLowerCase();
    tableRows = []
    url = 'AssetsAjax?'+which+'='+what+''
    $.getScript(url, function() {
        $("#assets").find("tr:gt(0)").remove();
        BuildTable(0);
    });
}

function GetType(typeID) {
    var t = types[typeID];
    if (t == undefined) {
            return t
    }
    t[t.length] = groups[t[2]];
    t[t.length] = categories[t[3]];
    t[t.length] = metaNames[t[1]];
    return t;
}

function AddItem(itemID, typeID, qty, locationID, solarSystemID, ownerName, locationName, numChildren, worth, jumps) {
    t = GetType(typeID);
    if (t == undefined) return;
    typeName = t[0];
    groupName = t[4];
    categoryName = t[5];
    metaName = t[6];
    groupID = t[2];
    categoryID = t[3];
    img = "<img height=\"32\" src=\"/static/images/32_32/" + typeID + ".png\" class=\"typeicon\" style=\"display:none;\">";
    metaImg = '';
    if (metaName != "Tech I" && 0) {
        p = "0"
        metaImg = 'background-repeat:no-repeat; background-image:url(\'/static/images/' + metaName.replace(" ", "") + '.png\'); background-position:'+p+'px 0px; '
	}
	imgcont = '';
    if (worth == 0) worth = "<span style=\"color:gray;\">unknown</span>";
    typeName2 = img + ' ' + typeName;
    if (locationID > 100000000) typeName2 = "&nbsp;&nbsp;&nbsp; " + typeName2;
    if (numChildren > 0) {
        imgcont = ' <img height=16 src="../static/images/container.png" title="Container has children">'
    }
    tableRows.push('<tr class=item ownerName="'+ownerName+'" numChildren="'+numChildren+'" typeID="'+typeID+'" itemID="'+itemID+'" typeName="'+typeName+'" groupID="'+groupID+'" groupName="'+groupName+'" categoryID="'+categoryID+'" categoryName="'+categoryName+'" locationID="'+locationID+'" solarSystemID="'+solarSystemID+'" metaName="'+metaName+'"><td align=center  style="'+metaImg+'"></td><td><nobr><span class=link OnClick=\"CCPEVE.showInfo(' + typeID + ', ' + itemID + ');\">' + typeName2 + imgcont + '</span></nobr></td><td>' + qty + '</td><td>' + groupName + '</td><td>' + categoryName + '</td><td>' + metaName + '</td><td><nobr>' + ownerName + '</nobr></td><td>' + worth + '</td><td>' + locationName + '</td><td>' + jumps + '</td></tr>');
}

function AddHeader(stationID, stationName, solarSystemID, sec, typeID) {
	secClass = "sec_red";
	if (sec >= 0.5) secClass = "sec_green";
	tableRows.push("<tr class=station typeID=\""+typeID+"\" stationID=\""+stationID+"\" solarSystemID=\""+solarSystemID+"\"><th colspan=\"10\" title=\"security: "+sec+"\"><span class=\"" + secClass + "\">&middot;</span> " + stationName + "</th></tr>");
}
    
function AddSummary(summary) {
    $("#summary").html(summary);
}
    
function BuildTable(st) {
    if (st == 0)
        $('#build').hide();
    var txt = "";
    var ed = st+500;
    if (ed >= tableRows.length) ed = tableRows.length;
        for (i = st; i < ed; i++) txt += tableRows[i];
        $('#assets tr:last').after(txt);
        if (ed < tableRows.length) setTimeout('BuildTable('+ed+');', 100);
        else {	
           $('#loading').hide();
           $(".zebra tr:even").addClass("even");
           $(".zebra tr:odd").addClass("odd");
           //TODO: Move to jQuery.live(...)
           bindItemMenu();
           bindStationMenu();
        }
    if (parseInt($.cookie("typeicons")))
        $(".typeicon").show();
}

function ToggleTypeIcons() {
	var wasIt = parseInt($.cookie("typeicons"));
	var isIt = wasIt ? 0 : 1;
	$.cookie("typeicons", isIt, {expires: 365});
	if (isIt) $(".typeicon").show();
	else $(".typeicon").hide();
}

function WriteFilterLinks(links) {

    if (links.length == 1 && links[0] == "_") {
        $("#filters").html("");
        return;
    }
    var ctrl = $('<div></div>');
    var ignor = null;
    $.each(links, function(key, val) {
		if (val == "type") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('type', 'reset');\">Reset Type Filter</span>"));
		}
		else if (val == "group") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('group', 'reset');\">Reset Group Filter</span>"));
		}
		else if (val == "category") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('category', 'reset');\">Reset Category Filter</span>"));
		}
		else if (val == "meta") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('meta', 'reset');\">Reset Metalevel Filter</span>"));
		}
		else if (val == "owner") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('owner', 'reset');\">Reset Character Filter</span>"));
		}
		else if (val == "location") {
			ctrl.append($("<span class=\"link\" onclick=\"FilterAssets('location', 'reset');\">Reset Location Filter</span>"));
		}
        if (val == "ignore") {
            ignor = $("<span class=\"link\" onclick=\"FilterAssets('_ignore', 'reset');\">Reset Ignored List</span>");
        }
        if (key < links.length && val != "_" && links[key+1] != "_") {
            ctrl.append($("<span> &middot; </span>"));
        }
    });
	$("#filters").html("").append(ctrl);
    if (typeof ignor != 'undefined') {
        $("#filters").append(ignor);
    }
}

function checkEVEBrowser() {
    if (IsEVEBrower())
        return true;
    alert("Your are calling an EVE function. This is not supported outside the IGB");

}

function IsEVEBrower() {
    return (typeof CCPEVE != 'undefined');
}

function SetMultiWaypoints(wp) {
    var points = wp.split(",");
    if (!checkEVEBrowser())
        return;
    for (i = 0; i < points.length; i++) {
        CCPEVE.addWaypoint(points[i]);
    }
}

//Binding Menu Behavior
function bindAgentMenu() {
    $('.agent').contextMenu('agentMenu', {
        bindings: {
                'showinfo': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var agentTypeID = $(t).attr('agentTypeID');
                    var agentID = $(t).attr('agentID');
                    CCPEVE.showInfo(agentTypeID, agentID);
                },
                'startConversation': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var agentTypeID = $(t).attr('agentTypeID');
                    var agentID = $(t).attr('agentID');
                    CCPEVE.startConversation(agentID);
                },

                'setdestination': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var solarSystemID = $(t).attr('solarSystemID');
                    CCPEVE.setDestination(solarSystemID);
                },
                'addwaypoint': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var solarSystemID = $(t).attr('solarSystemID');
                    CCPEVE.addWaypoint(solarSystemID);
                },
                'showcoreinfo': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var coreTypeID = $(t).attr('coreTypeID');
                    CCPEVE.showInfo(coreTypeID);
                },
                'showcoremarketdetails': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var coreTypeID = $(t).attr('coreTypeID');
                    CCPEVE.showMarketDetails(coreTypeID);
                },
                'filterbycharacter': function(t) {
                    if (!checkEVEBrowser())
                        return;
                    var characterID = $(t).attr('characterID');
                    window.location.href = '?characterID=' + characterID;
                }
        }
    });
}

function bindItemMenu() {
   $('.item').contextMenu('itemMenu', {
      onShowMenu: function(e, menu) {
        if ($(e.target.parentNode).attr('categoryName') != 'Ship') {
          $('#preview', menu).remove();
        }
        if ($(e.target.parentNode).attr('locationID') > 100000000) {
          $('#filtersolarsystem', menu).remove();
          $('#filterconstellation', menu).remove();
          $('#filterregion', menu).remove();
          $('#setdestination', menu).remove();
        }
        if ($(e.target.parentNode).attr('numChildren') == '0') {
          $('#showContents', menu).remove();
        }
        return menu;
        },
      bindings: {
        'itemMenu-showinfo': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            CCPEVE.showInfo(typeID, itemID);
        },
        'itemMenu-preview': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            CCPEVE.showPreview(typeID);
        },
        'itemMenu-showMarketDetails': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            CCPEVE.showMarketDetails(typeID);
        },
        'itemMenu-sellItem': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var locationID = $(t).attr('locationID');
            var itemID = $(t).attr('itemID');
            CCPEVE.sellItem(locationID, itemID);
        },
        'itemMenu-buyType': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            CCPEVE.buyType(typeID);
        },
        'itemMenu-findInContracts': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            CCPEVE.findInContracts(typeID);
        },
        'itemMenu-createContract': function(t) {
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            var locationID = $(t).attr('locationID');
            CCPEVE.createContract(1, locationID, itemID);
        },
        'itemMenu-addToMarketQuickBar': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            CCPEVE.addToMarketQuickBar(typeID);
        },
        'itemMenu-showContents': function(t) {
            if (!checkEVEBrowser())
                return;
            var typeID = $(t).attr('typeID');
            var itemID = $(t).attr('itemID');
            var locationID = $(t).attr('locationID');
            CCPEVE.showContents(locationID, itemID);
        },
        'itemMenu-filtertype': function(t) {
            var typeID = $(t).attr('typeID');
            FilterAssets('type', typeID);
        },
        'itemMenu-filtergroup': function(t) {
            var groupID = $(t).attr('groupID');
            FilterAssets('group', groupID);
        },
        'itemMenu-filtercategory': function(t) {
            var categoryID = $(t).attr('categoryID');
            FilterAssets('category', categoryID);
        },
        'itemMenu-filtermeta': function(t) {
            var metaName = $(t).attr('metaName');
            FilterAssets('meta', metaName);
        },
        'itemMenu-filterowner': function(t) {
            var ownerName = $(t).attr('ownerName');
            FilterAssets('owner', ownerName);
        },
        'itemMenu-ignoretype': function(t) {
            var typeID = $(t).attr('typeID');
            FilterAssets('type_ignore', typeID);
        },
        'itemMenu-ignoregroup': function(t) {
            var groupID = $(t).attr('groupID');
            FilterAssets('group_ignore', groupID);
        },
        'itemMenu-ignorecategory': function(t) {
            var categoryID = $(t).attr('categoryID');
            FilterAssets('category_ignore', categoryID);
        },
        'itemMenu-setdestination': function(t) {
            if (!checkEVEBrowser())
                return;
            var solarSystemID = $(t).attr('solarSystemID');
            CCPEVE.setDestination(solarSystemID);
        },
        'itemMenu-filtersolarsystem': function(t) {
            var locationID = $(t).attr('locationID');
            FilterAssets('solarsystem', locationID);
        },
        'itemMenu-filterconstellation': function(t) {
            var locationID = $(t).attr('locationID');
            FilterAssets('constellation', locationID);
        },
        'itemMenu-filterregion': function(t) {
            var locationID = $(t).attr('locationID');
            FilterAssets('region', locationID);
        }
      }
    });
}

function bindStationMenu() {
    $('.station').contextMenu('stationMenu', {
      bindings: {
        'stationMenu-showinfo': function(t) {
            var typeID = $(t).attr('typeID');
            var stationID = $(t).attr('stationID');
            CCPEVE.showInfo(typeID, stationID);
        },
        'stationMenu-preview': function(t) {
            var typeID = $(t).attr('typeID');
            CCPEVE.showPreview(typeID);
        },

        'stationMenu-setdestination': function(t) {
            var solarSystemID = $(t).attr('solarSystemID');
            CCPEVE.setDestination(solarSystemID);
        },
        'stationMenu-filtersolarsystem': function(t) {
            var stationID = $(t).attr('stationID');
            //alert('filtersolarsystem '+ stationID);
            FilterAssets('solarsystem', stationID);
        },
        'stationMenu-filterconstellation': function(t) {
            var stationID = $(t).attr('stationID');
            //alert('filterconstellation '+ stationID);
            FilterAssets('constellation', stationID);
        },
        'stationMenu-filterregion': function(t) {
            var stationID = $(t).attr('stationID');
            //alert('filterregion '+ stationID);
            FilterAssets('region', stationID);
        },
        'stationMenu-ignorestation': function(t) {
            var stationID = $(t).attr('stationID');
            FilterAssets('location_ignore', stationID);
        }
      }
    });
}

function CheckSession() {
    url = "CheckSession"
    $.get(url, function(data) {
	if (data == "RELOAD") {
	    window.location.reload();
	}
	});
    setTimeout('CheckSession()', 10000);
}
